# 🔧 Database Configuration - 4 Variables Only

## ✅ Configuration Complete

Your system requires **ONLY 4 variables** to work:

### File: `includes/config.php` (Lines 7-10)

```php
define('DB_HOST', 'localhost');   // MySQL Server Host
define('DB_USER', 'root');        // MySQL Username
define('DB_PASS', '');            // MySQL Password
define('DB_NAME', 'hotel_db');    // Database Name
```

---

## 📝 Configuration Options

### Option 1: Default Setup (No Password)
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'hotel_db');
```

### Option 2: With Password
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', 'your_password_here');
define('DB_NAME', 'hotel_db');
```

### Option 3: Remote MySQL Server
```php
define('DB_HOST', '192.168.1.100');
define('DB_USER', 'hotel_user');
define('DB_PASS', 'secure_password');
define('DB_NAME', 'hotel_db');
```

### Option 4: cPanel/Shared Hosting
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'cpanel_username_dbname');
define('DB_PASS', 'cpanel_password');
define('DB_NAME', 'cpanel_username_dbname');
```

---

## ✨ That's It!

Everything else works automatically:
- ✅ **PDO Connection** - Uses these 4 variables
- ✅ **All Queries** - Use the $pdo connection
- ✅ **Admin Panel** - Uses these 4 variables
- ✅ **Public Website** - Uses these 4 variables
- ✅ **Database Operations** - All automated

---

## 🚀 How to Connect

### Step 1: Edit `includes/config.php`
Update only lines 7-10 with your credentials

### Step 2: Create Database
```sql
CREATE DATABASE IF NOT EXISTS hotel_db;
```

### Step 3: Import Schema
```powershell
mysql -u root -p < database\hotel_db.sql
```

### Step 4: Access Application
- Public: `http://localhost/hotel/public/index.php`
- Admin: `http://localhost/hotel/admin/login.php`

---

## ✅ Verification Checklist

- [ ] `DB_HOST` is correct (localhost or IP)
- [ ] `DB_USER` exists in MySQL
- [ ] `DB_PASS` is correct (empty or password)
- [ ] `DB_NAME` exists (hotel_db)
- [ ] Database tables are created
- [ ] Can login to admin panel

---

## 📊 What Gets Created

Once these 4 variables connect, the system automatically:

✅ **10 Database Tables**
- admin_users
- room_categories
- rooms
- guests
- bookings
- payments
- reviews
- amenities
- room_amenities
- activity_logs

✅ **Complete Admin Panel**
- Login system
- Dashboard with statistics
- Room management
- Booking management
- Guest management
- Payment tracking
- Review management
- User management
- Activity logging

✅ **Public Website**
- Homepage
- Room listings
- Booking form
- Contact page

---

## 🔐 That's All You Need!

No other configuration required. These 4 variables power your entire hotel management system.

**Update them once and everything works! 🚀**
