# 🏨 GreenDoors Hotel Management System - Complete Setup Guide

## 🚀 QUICK LINKS

### 📖 Documentation
1. **[README.md](README.md)** - Full documentation & features
2. **[QUICKSTART.md](QUICKSTART.md)** - 5-minute setup guide
3. **[PROJECT_SUMMARY.md](PROJECT_SUMMARY.md)** - Project overview & stats

### 🌐 Access Your System

| Section | URL | Purpose |
|---------|-----|---------|
| **Public Home** | `/public/index.php` | Guest homepage with booking search |
| **Room Listing** | `/public/rooms.php` | Browse all room categories |
| **Make Booking** | `/public/booking.php` | Complete a room reservation |
| **Contact Us** | `/public/contact.php` | Send messages & get support info |
| **Admin Login** | `/admin/login.php` | Access management panel |
| **Admin Dashboard** | `/admin/index.php` | View stats & manage system |

### 👤 Demo Credentials
```
Username: admin
Password: admin123
```

## ⚙️ Installation Checklist

- [ ] Extract project files to web server
- [ ] Import `database/hotel_db.sql` into MySQL
- [ ] Verify database name is `hotel_db`
- [ ] Check `includes/config.php` database settings
- [ ] Access public home page
- [ ] Login to admin panel
- [ ] Test booking form
- [ ] Change admin password

## 📂 File Structure

```
hotel/
├── README.md                    ← Full documentation
├── QUICKSTART.md               ← Setup guide
├── PROJECT_SUMMARY.md          ← Project overview
│
├── admin/                       ← Admin panel modules
│   ├── login.php               ← Admin login
│   ├── index.php               ← Dashboard
│   ├── rooms.php               ← Room management
│   ├── bookings.php            ← Booking management
│   ├── guests.php              ← Guest profiles
│   ├── payments.php            ← Payment tracking
│   ├── reviews.php             ← Reviews & ratings
│   ├── categories.php          ← Room categories
│   ├── admin-users.php         ← User management
│   ├── activity-logs.php       ← Audit logs
│   └── logout.php              ← Logout handler
│
├── public/                      ← Public website
│   ├── index.php               ← Homepage
│   ├── rooms.php               ← Room listing
│   ├── booking.php             ← Booking form
│   └── contact.php             ← Contact page
│
├── includes/
│   └── config.php              ← DB config & helpers
│
├── database/
│   └── hotel_db.sql            ← MySQL schema
│
├── api/                         ← API endpoints
│   ├── rooms.php               ← Room API
│   └── bookings.php            ← Booking API
│
└── assets/
    ├── css/
    │   ├── admin-style.css     ← Admin styling
    │   └── public-style.css    ← Public styling
    ├── js/
    │   └── admin-script.js     ← Admin functions
    └── images/                 ← Image directory
```

## 🎯 Key Features

### 🔐 Security
- Bcrypt password hashing
- SQL injection protection
- Session management
- Role-based access control
- Complete audit logging

### 🛏️ Rooms
- 5 pre-configured categories
- Status tracking
- Amenity associations
- Occupancy limits

### 📅 Bookings
- Date range selection
- Availability checking
- Price calculation
- Status tracking

### 💰 Payments
- Multiple payment methods
- Transaction tracking
- Revenue reporting

### 👥 Guests
- Profile management
- Contact information
- Booking history

### 📊 Analytics
- Real-time dashboard
- Revenue reports
- Occupancy stats

### 🎨 Design
- Modern green/olive theme
- Fully responsive
- Bootstrap 5.3
- Smooth animations

## 🔧 Database Configuration

Edit `includes/config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'hotel_db');
```

## 📱 Responsive Breakpoints

- Mobile: 320px - 767px
- Tablet: 768px - 1199px
- Desktop: 1200px+

## 🎨 Color Reference

```
Primary Green: #4a7c59
Secondary: #6b9a7a
Accent: #a4c96f
Dark: #2d5a3d
Light BG: #f8faf6
```

## 🚦 Quick Status Checks

### Test Login
1. Go to `/admin/login.php`
2. Enter: admin / admin123
3. Should redirect to dashboard

### Test Booking
1. Go to `/public/booking.php`
2. Fill form with sample data
3. Should create booking successfully

### Test API
```
GET /api/rooms.php
GET /api/bookings.php
```

## 📊 Sample Data Included

- 5 room categories
- 10 amenities
- 1 admin user
- Ready for testing

## 🔄 Database Tables

1. **admin_users** - Admin accounts
2. **room_categories** - Room types
3. **rooms** - Room inventory
4. **guests** - Guest info
5. **bookings** - Reservations
6. **payments** - Transactions
7. **reviews** - Ratings
8. **amenities** - Features
9. **room_amenities** - Mappings
10. **activity_logs** - Audit trail

## ⚡ Performance

- Optimized queries
- Indexed fields
- Prepared statements
- Ready for caching

## 📞 Support

- Check **README.md** for details
- Review **QUICKSTART.md** for setup help
- Check **PROJECT_SUMMARY.md** for overview

## 🏁 Next Steps

1. ✅ Install database
2. ✅ Verify configuration
3. ✅ Test login (admin/admin123)
4. ✅ Change admin password
5. ✅ Customize information
6. ✅ Add your images
7. ✅ Set up email (optional)
8. ✅ Deploy to production

## 📅 Maintenance Tasks

- [ ] Weekly: Backup database
- [ ] Monthly: Review activity logs
- [ ] Quarterly: Update password policy
- [ ] Yearly: Review security settings

## 🚀 Deployment

The system is production-ready:
- All security features enabled
- Database optimized
- Code well-tested
- Documentation complete

Ready to deploy to:
- Shared hosting
- VPS
- Dedicated server
- Cloud platforms

## 💡 Tips

1. **Change default password immediately**
2. **Backup database regularly**
3. **Review activity logs weekly**
4. **Update room information**
5. **Customize contact details**
6. **Add your hotel images**
7. **Test all features**
8. **Monitor bookings daily**

## 🎓 Learning Resources

- Code is well-commented
- Database schema is normalized
- Helper functions are documented
- API endpoints are ready
- CSS is modular

## 📈 What's Included

✅ Complete admin panel  
✅ Public website  
✅ Database system  
✅ Security features  
✅ Documentation  
✅ Sample data  
✅ API endpoints  
✅ Responsive design  

## 🎉 You're All Set!

Your hotel management system is ready to use!

**Start here**:
1. Public Home: `http://localhost/hotel/public/index.php`
2. Admin Login: `http://localhost/hotel/admin/login.php`
3. Username: `admin` | Password: `admin123`

---

For detailed information, see:
- **Full Guide**: [README.md](README.md)
- **Quick Setup**: [QUICKSTART.md](QUICKSTART.md)
- **Project Info**: [PROJECT_SUMMARY.md](PROJECT_SUMMARY.md)

**Happy hotel managing!** 🏨✨
