# GreenDoors Hotel - Quick Start Guide

Get your hotel management system up and running in 5 minutes!

## 🚀 Quick Installation

### Step 1: Download & Extract
1. Extract the hotel management system to your web server:
   - **XAMPP Users**: Extract to `C:\xampp\htdocs\hotel\`
   - **WAMP Users**: Extract to `C:\wamp\www\hotel\`
   - **Linux Users**: Extract to `/var/www/html/hotel/`

### Step 2: Create Database
1. Open phpMyAdmin: `http://localhost/phpmyadmin`
2. Click "New" to create a new database
3. Name it: `hotel_db`
4. Click "Create"
5. Select the new `hotel_db` database
6. Click "Import"
7. Select file: `database/hotel_db.sql`
8. Click "Import"

**✅ Database is ready with sample data!**

### Step 3: Verify Configuration
1. Open `includes/config.php`
2. Check these settings match your environment:
   ```php
   define('DB_HOST', 'localhost');      // Usually localhost
   define('DB_USER', 'root');           // Usually root
   define('DB_PASS', '');               // Usually empty
   define('DB_NAME', 'hotel_db');       // Database name
   ```

### Step 4: Access the Application

#### Public Website
```
👉 http://localhost/hotel/public/index.php
```

Features:
- 🏨 Modern homepage with booking search
- 🛏️ Room categories showcase
- 📅 Easy booking form
- 📧 Newsletter signup
- 💬 Customer testimonials

#### Admin Panel
```
👉 http://localhost/hotel/admin/login.php
```

Demo Credentials:
- **Username**: `admin`
- **Password**: `admin123`

## 📊 Admin Panel Features

### Dashboard
- 📈 Real-time statistics
- 📅 Today's check-ins
- 💰 Total revenue
- 📊 Recent bookings

### Rooms
- View all rooms
- Manage room status
- Assign categories
- Track maintenance

### Bookings
- View all bookings
- Update booking status
- Manage guest reservations
- Track booking references

### Guests
- Guest profiles
- Booking history
- Contact information
- ID verification

### Payments
- Payment tracking
- Revenue reports
- Transaction history
- Payment methods

### Reviews
- Guest ratings
- Review management
- Average ratings
- Guest feedback

### Categories
- Room types
- Pricing management
- Capacity settings
- Amenities list

### Admin Users
- Manage admin accounts
- User roles
- Activity tracking
- Access control

### Activity Logs
- Complete audit trail
- Admin actions
- Timestamp recording
- IP tracking

## 🎨 Default Color Scheme

The system uses a premium green/olive color palette:

| Element | Color | Usage |
|---------|-------|-------|
| Primary Button | `#4a7c59` | Main actions |
| Hover States | `#6b9a7a` | Interactive elements |
| Accents | `#a4c96f` | Highlights |
| Dark Text | `#2d5a3d` | Important text |
| Light Background | `#f8faf6` | Page backgrounds |

## 📁 Important Files

```
hotel/
├── admin/login.php              👈 Start here to login
├── public/index.php             👈 Public home page
├── includes/config.php          👈 Database settings
├── database/hotel_db.sql        👈 Database schema
├── assets/css/
│   ├── admin-style.css         👈 Admin styling
│   └── public-style.css        👈 Public styling
└── README.md                    👈 Full documentation
```

## 🔧 Common Tasks

### Change Admin Password
1. Login to admin panel
2. Go to "Admin Users"
3. Click edit on your account
4. Change password
5. Save changes

### Add New Room
1. Login to admin panel
2. Go to "Rooms" → Add New
3. Enter room number
4. Select category
5. Set floor number
6. Save

### View Bookings
1. Login to admin panel
2. Click "Bookings"
3. See all guest reservations
4. Click actions to edit or cancel

### Customize Contact Info
1. Edit `public/contact.php`
2. Find the contact information section:
   ```php
   <h5>Address</h5>
   <p>123 Hotel Street<br>Bali, Indonesia 80361</p>
   ```
3. Update with your information
4. Save the file

## 🛡️ Security First

### Change Default Password
```
⚠️ IMPORTANT: Change the default admin password!

1. Login with: admin / admin123
2. Go to Admin Users section
3. Click your profile
4. Change password to something secure
5. Save changes
```

### Database Backup
```bash
# Backup your database regularly:
mysqldump -u root -p hotel_db > backup.sql

# Restore from backup:
mysql -u root -p hotel_db < backup.sql
```

## 🐛 Troubleshooting

### Issue: "Database connection failed"
**Solution:**
1. Check `includes/config.php` settings
2. Ensure MySQL is running
3. Verify database `hotel_db` exists
4. Check username and password

### Issue: "Login not working"
**Solution:**
1. Clear browser cache (Ctrl+F5)
2. Check database connection
3. Verify admin user exists in database:
   ```sql
   SELECT * FROM admin_users WHERE username = 'admin';
   ```

### Issue: "Styling looks broken"
**Solution:**
1. Clear browser cache
2. Check Bootstrap CDN is accessible
3. Verify CSS file paths are correct
4. Check browser console for errors (F12)

### Issue: "Can't see room images"
**Solution:**
1. Images load from Unsplash API
2. Check internet connection
3. Try a different browser
4. Images are placeholders - add your own in `assets/images/`

## 📱 Responsive Design

The application works on:
- 📱 Mobile phones (320px+)
- 📱 Tablets (768px+)
- 💻 Desktops (1200px+)

Test responsiveness:
1. Open admin panel or public site
2. Press F12 (Developer Tools)
3. Click responsive design mode
4. Test on different screen sizes

## 🚀 Performance Tips

### Optimize Database
```sql
-- Analyze tables for better performance
ANALYZE TABLE bookings;
ANALYZE TABLE rooms;
ANALYZE TABLE guests;
```

### Enable Caching
Add to `.htaccess`:
```
<IfModule mod_expires.c>
    ExpiresActive On
    ExpiresByType image/jpeg "access plus 1 month"
    ExpiresByType text/css "access plus 1 week"
</IfModule>
```

### Minimize CSS/JS
- Minify asset files
- Remove unused CSS
- Combine small images

## 📞 Support Resources

### Need Help?
1. Check the main [README.md](README.md)
2. Review database schema
3. Check browser console (F12)
4. Enable PHP error logging

### File Permissions
```bash
# Linux/Mac - Set proper permissions:
chmod 755 hotel/          # Directory
chmod 644 hotel/*.php     # PHP files
chmod 755 hotel/assets/   # Assets folder
```

## 🎯 Next Steps

1. ✅ **Install & Setup** (You're here!)
2. 📝 **Customize Information** - Add your hotel details
3. 🖼️ **Add Your Images** - Replace placeholder images
4. 🎨 **Brand Colors** - Update color scheme to match your brand
5. 📧 **Email Setup** - Configure email notifications
6. 💳 **Payment Gateway** - Integrate payment processor
7. 📱 **Mobile App** - Consider mobile app development

## 📚 Learning Path

**Beginner:**
- Understand the file structure
- Create a test booking
- Explore admin dashboard
- Review sample data

**Intermediate:**
- Customize HTML/CSS
- Modify room categories
- Add your content
- Test all features

**Advanced:**
- Extend database schema
- Create custom modules
- API integration
- Third-party services

## 🎉 You're All Set!

Your hotel management system is ready to use!

### Quick Links
- 📖 Full Documentation: [README.md](README.md)
- 🗄️ Database Schema: [hotel_db.sql](database/hotel_db.sql)
- ⚙️ Configuration: [config.php](includes/config.php)
- 🎨 Public Styling: [public-style.css](assets/css/public-style.css)

---

**Questions?** Check the README.md for comprehensive documentation.

**Ready to customize?** Open the HTML files and start editing!

**Need more features?** Review the database schema and helper functions in config.php.

Happy hotel managing! 🏨✨
