# 🚀 GreenDoors Hotel System - START HERE

## ⚡ Quick Start (3 Steps)

### Step 1: Start MySQL
```powershell
# Open PowerShell as Administrator and run:
Start-Service -Name "MySQL80"

# Verify it's running:
Get-Service -Name "MySQL80"
```

### Step 2: Create Database
```powershell
# Run in PowerShell:
mysql -u root -p < database\hotel_db.sql
# When prompted for password: press Enter (if no password set)
```

### Step 3: Access Application
| Component | URL |
|-----------|-----|
| **Public Home** | http://localhost/hotel/public/index.php |
| **Admin Panel** | http://localhost/hotel/admin/login.php |
| **Test Connection** | http://localhost/hotel/test_connection.php |

---

## 🔐 Admin Credentials
```
Username: admin
Password: admin123
```

---

## ⚙️ Database Configuration

**File:** `includes/config.php` (lines 7-10)

```php
define('DB_HOST', 'localhost');   // MySQL host
define('DB_USER', 'root');        // MySQL username
define('DB_PASS', '');            // MySQL password (empty by default)
define('DB_NAME', 'hotel_db');    // Database name
```

**If you have a MySQL password, update line 9:**
```php
define('DB_PASS', 'your_password_here');
```

---

## 🔍 Troubleshooting

### MySQL Service Not Starting?
```powershell
# Check service name:
Get-Service -Name "*MySQL*"

# Common names: MySQL80, MySQL57, MariaDB
```

### Connection Still Failing?
1. Verify MySQL is running: `Get-Service -Name "MySQL80"`
2. Check credentials in `includes/config.php`
3. Ensure database exists: `mysql -u root -p -e "SHOW DATABASES;"`
4. Test with: `http://localhost/hotel/test_connection.php`

### No Database?
```powershell
# Import manually:
mysql -u root -p < database\hotel_db.sql
```

---

## 📁 Project Structure
```
hotel/
├── public/              ← Public website
│   ├── index.php       ← Home page
│   ├── booking.php     ← Booking form
│   ├── rooms.php       ← Room listing
│   └── contact.php     ← Contact page
│
├── admin/              ← Admin panel
│   ├── login.php       ← Admin login
│   ├── index.php       ← Dashboard
│   └── *.php           ← Other modules
│
├── includes/
│   └── config.php      ← Configuration & helpers
│
├── database/
│   └── hotel_db.sql    ← Database schema
│
└── assets/
    ├── css/            ← Stylesheets
    ├── js/             ← JavaScript
    └── images/         ← Images
```

---

## 🌐 Access Points

| Page | Purpose | URL |
|------|---------|-----|
| **Homepage** | Guest homepage with search | /public/index.php |
| **Rooms** | Browse all rooms | /public/rooms.php |
| **Booking** | Make a reservation | /public/booking.php |
| **Contact** | Contact information | /public/contact.php |
| **Admin Login** | Admin authentication | /admin/login.php |
| **Dashboard** | Admin statistics | /admin/index.php |
| **Test DB** | Verify connection | /test_connection.php |

---

## 📊 Database Tables (10)
- ✅ admin_users
- ✅ room_categories
- ✅ rooms
- ✅ guests
- ✅ bookings
- ✅ payments
- ✅ reviews
- ✅ amenities
- ✅ room_amenities
- ✅ activity_logs

---

## 🎯 What's Included

✅ **Admin Panel** - Complete management system  
✅ **Public Website** - Beautiful hotel booking site  
✅ **Database** - Fully normalized schema  
✅ **Security** - Bcrypt passwords, prepared statements  
✅ **Responsive** - Works on all devices  
✅ **Sample Data** - Ready to test  

---

## 💡 Next Steps

1. ✅ Start MySQL service
2. ✅ Import database
3. ✅ Test connection
4. ✅ Login to admin panel
5. ✅ Explore features
6. ✅ Customize as needed

---

## 📞 Need Help?

See detailed guides:
- **Full Docs**: [README.md](README.md)
- **Setup Help**: [QUICKSTART.md](QUICKSTART.md)
- **Issues**: [TROUBLESHOOT.md](TROUBLESHOOT.md)
- **Project Info**: [PROJECT_SUMMARY.md](PROJECT_SUMMARY.md)
- **Navigation**: [INDEX.md](INDEX.md)

---

## 🏁 Ready to Go!

Your hotel management system is ready to use. Follow the 3 steps above and you'll be up and running in minutes! 🎉

**Questions? Check the documentation files or the troubleshooting guide.**
