<?php
require_once __DIR__ . '/../includes/config.php';

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

// Create booking via API
if ($method === 'POST') {
    try {
        $data = json_decode(file_get_contents('php://input'), true);
        
        $guest_id = $data['guest_id'] ?? null;
        $room_id = $data['room_id'] ?? null;
        $check_in = $data['check_in'] ?? null;
        $check_out = $data['check_out'] ?? null;
        $total_price = $data['total_price'] ?? 0;
        
        if (!$guest_id || !$room_id || !$check_in || !$check_out) {
            respondJson(false, 'Missing required fields');
        }
        
        $booking_reference = generateBookingReference();
        
        $stmt = $pdo->prepare("
            INSERT INTO bookings (
                booking_reference, guest_id, room_id, check_in_date, check_out_date,
                total_price, status
            ) VALUES (?, ?, ?, ?, ?, ?, 'pending')
        ");
        
        $stmt->execute([$booking_reference, $guest_id, $room_id, $check_in, $check_out, $total_price]);
        
        $booking_id = dbLastInsertId();
        
        respondJson(true, 'Booking created successfully', [
            'booking_id' => $booking_id,
            'booking_reference' => $booking_reference
        ]);
        
    } catch (Exception $e) {
        respondJson(false, 'Error creating booking: ' . htmlspecialchars($e->getMessage()));
    }
}

// Get bookings
if ($method === 'GET') {
    try {
        $stmt = $pdo->query("
            SELECT b.*, g.first_name, g.last_name, g.email,
                   r.room_number, rc.category_name
            FROM bookings b
            JOIN guests g ON b.guest_id = g.id
            JOIN rooms r ON b.room_id = r.id
            JOIN room_categories rc ON r.category_id = rc.id
            ORDER BY b.created_at DESC
        ");
        
        $bookings = $stmt->fetchAll();
        respondJson(true, 'Bookings retrieved successfully', $bookings);
        
    } catch (Exception $e) {
        respondJson(false, 'Error retrieving bookings: ' . htmlspecialchars($e->getMessage()));
    }
}

respondJson(false, 'Method not supported');
