<?php
require_once __DIR__ . '/../includes/config.php';

header('Content-Type: application/json');

// Get request method
$method = $_SERVER['REQUEST_METHOD'];

// Get rooms or filtered by category
if ($method === 'GET') {
    try {
        $category_id = $_GET['category_id'] ?? null;
        
        if ($category_id) {
            $stmt = $pdo->prepare("
                SELECT r.*, rc.category_name, rc.base_price
                FROM rooms r
                JOIN room_categories rc ON r.category_id = rc.id
                WHERE r.category_id = ? AND r.status = 'available'
                ORDER BY r.room_number
            ");
            $stmt->execute([$category_id]);
        } else {
            $stmt = $pdo->query("
                SELECT r.*, rc.category_name, rc.base_price
                FROM rooms r
                JOIN room_categories rc ON r.category_id = rc.id
                WHERE r.status = 'available'
                ORDER BY r.room_number
            ");
        }
        
        $rooms = $stmt->fetchAll();
        respondJson(true, 'Rooms retrieved successfully', $rooms);
        
    } catch (Exception $e) {
        respondJson(false, 'Error retrieving rooms: ' . htmlspecialchars($e->getMessage()));
    }
}

// Other methods can be added for POST, PUT, DELETE
respondJson(false, 'Method not supported');
