<?php
require_once __DIR__ . '/../includes/config.php';

// Fetch featured room categories
try {
    $stmt = $pdo->query("
        SELECT rc.*, COUNT(r.id) as total_rooms, 
               SUM(CASE WHEN r.status = 'available' THEN 1 ELSE 0 END) as available_rooms
        FROM room_categories rc
        LEFT JOIN rooms r ON rc.id = r.category_id
        GROUP BY rc.id
        ORDER BY rc.base_price ASC
        LIMIT 3
    ");
    $featured_rooms = $stmt->fetchAll();
} catch (Exception $e) {
    $featured_rooms = [];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Gateway to Comfort and Convenience - GreenDoors Hotel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/public-style.css">
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-custom sticky-top">
        <div class="container-fluid px-4">
            <a class="navbar-brand fw-bold" href="index.php">
                <i class="fas fa-cube"></i> GreenDoors
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="#home">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="rooms.php">Services</a></li>
                    <li class="nav-item"><a class="nav-link" href="#events">Events</a></li>
                    <li class="nav-item"><a class="nav-link" href="#blog">Blog</a></li>
                    <li class="nav-item"><a class="nav-link" href="#resources">Resources</a></li>
                    <li class="nav-item"><a class="nav-link" href="booking.php">Signup</a></li>
                    <li class="nav-item"><a class="nav-link login-btn" href="../admin/login.php">LOGIN</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section with Search -->
    <section class="hero-section" id="home">
        <div class="hero-content">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <h1 class="hero-title">Your Gateway<br>to Comfort and<br>Convenience.</h1>
                        <p class="hero-subtitle">Book now and get the best prices</p>
                    </div>
                    <div class="col-lg-6">
                        <div class="hero-image">
                            <img src="https://images.unsplash.com/photo-1631049307264-da0ec9d70304?w=500&h=500&fit=crop" alt="Luxury Room">
                        </div>
                    </div>
                </div>

                <!-- Search Form -->
                <div class="search-form mt-5">
                    <form action="booking.php" method="GET" class="search-container">
                        <div class="search-group">
                            <label>Location</label>
                            <input type="text" placeholder="Bali, Indonesia" name="location">
                        </div>
                        <div class="search-group">
                            <label>Check in</label>
                            <input type="date" name="check_in" id="check_in">
                        </div>
                        <div class="search-group">
                            <label>Check out</label>
                            <input type="date" name="check_out" id="check_out">
                        </div>
                        <div class="search-group">
                            <label>Guests & Rooms</label>
                            <div class="guests-input">
                                <select name="number_of_guests">
                                    <option>1 Guest</option>
                                    <option>2 Guests</option>
                                    <option>3 Guests</option>
                                    <option>4+ Guests</option>
                                </select>
                                <span>|</span>
                                <select name="number_of_rooms">
                                    <option>1 Room</option>
                                    <option>2 Rooms</option>
                                    <option>3+ Rooms</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="search-btn">SEARCH</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Hotels Section -->
    <section class="featured-hotels py-5">
        <div class="container">
            <div class="section-header">
                <h2>Our Popular Hotels We<br>Recommend for You</h2>
                <p>We offers a curated selection of exceptional hotels that cater to your preferences and ensure a delightful stay</p>
            </div>

            <div class="row g-4 mt-4">
                <?php foreach ($featured_rooms as $room): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="hotel-card">
                            <div class="hotel-image">
                                <img src="https://images.unsplash.com/photo-1631049307264-da0ec9d70304?w=400&h=300&fit=crop" alt="<?php echo htmlspecialchars($room['category_name']); ?>">
                                <span class="hotel-rating"><i class="fas fa-star"></i> 4.8</span>
                            </div>
                            <div class="hotel-info">
                                <h5><?php echo htmlspecialchars($room['category_name']); ?></h5>
                                <p class="location"><i class="fas fa-map-marker-alt"></i> Bali, Indonesia</p>
                                <p class="description"><?php echo htmlspecialchars(substr($room['description'], 0, 60)); ?>...</p>
                                <div class="hotel-footer">
                                    <span class="price">$<?php echo number_format($room['base_price'], 0); ?><small>/night</small></span>
                                    <div class="rating-dots">
                                        <span class="dot"></span>
                                        <span class="dot"></span>
                                        <span class="dot"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Memories Section -->
    <section class="memories-section py-5">
        <div class="container">
            <div class="section-header text-center">
                <h2>Unforgettable Memories<br>Unparalleled Comfort</h2>
                <p>Experience ultimate travel comfort with our innovative hotel booking app. Explore a curated collection of exclusive hotels worldwide for an unforgettable experience.</p>
                <a href="rooms.php" class="btn-read-more">READ MORE</a>
            </div>

            <div class="memories-gallery mt-5">
                <div class="memory-item">
                    <img src="https://images.unsplash.com/photo-1631049307264-da0ec9d70304?w=300&h=400&fit=crop" alt="Memory 1">
                </div>
                <div class="memory-item">
                    <img src="https://images.unsplash.com/photo-1582719471384-894fbb16e074?w=300&h=400&fit=crop" alt="Memory 2">
                </div>
                <div class="memory-item">
                    <img src="https://images.unsplash.com/photo-1631049307264-da0ec9d70304?w=300&h=400&fit=crop" alt="Memory 3">
                </div>
            </div>
        </div>
    </section>

    <!-- Experience Section -->
    <section class="experience-section py-5">
        <div class="container text-center">
            <h2 class="mb-5">With Our Experience<br>We Will Serve You</h2>
            
            <div class="experience-circles mb-4">
                <div class="circle-item">
                    <svg viewBox="0 0 40 40" class="circle-svg">
                        <circle cx="20" cy="20" r="18" fill="none" stroke="currentColor" stroke-width="2"/>
                        <circle cx="20" cy="20" r="12" fill="none" stroke="currentColor" stroke-width="2"/>
                        <circle cx="20" cy="20" r="6" fill="currentColor"/>
                    </svg>
                </div>
            </div>

            <div class="row mt-5">
                <div class="col-md-4">
                    <div class="stat-item">
                        <h3>800+</h3>
                        <p>Cities</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-item">
                        <h3>35,000+</h3>
                        <p>Exclusive Hotels</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-item">
                        <h3>1.5M+</h3>
                        <p>Exclusive Rooms</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- News Section -->
    <section class="news-section py-5" id="blog">
        <div class="container">
            <div class="section-header d-flex justify-content-between align-items-center">
                <h2>Our Hot News</h2>
                <a href="#" class="show-more">SHOW MORE <i class="fas fa-arrow-right"></i></a>
            </div>

            <div class="row g-4 mt-4">
                <div class="col-lg-6">
                    <div class="news-item large">
                        <img src="https://images.unsplash.com/photo-1631049307264-da0ec9d70304?w=500&h=300&fit=crop" alt="News">
                        <div class="news-content">
                            <p class="news-meta"><i class="fas fa-clock"></i> 4 min read</p>
                            <h5>The Rise of Boutique Hotels: Unveiling Unique and Personalized Hospitality</h5>
                            <p>Explore the growing phenomenon of boutique hotels offering unique and personalized hospitality.</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="news-grid">
                        <div class="news-item small">
                            <img src="https://images.unsplash.com/photo-1582719471384-894fbb16e074?w=300&h=200&fit=crop" alt="News">
                            <h6>Hotels Go Beyond Accommodation to Create Memorable Stays</h6>
                            <a href="#">Read More</a>
                        </div>
                        <div class="news-item small">
                            <img src="https://images.unsplash.com/photo-1631049307264-da0ec9d70304?w=300&h=200&fit=crop" alt="News">
                            <h6>Luxury Reimagined: Iconic Hotels Undergo Renovation</h6>
                            <a href="#">Read More</a>
                        </div>
                        <div class="news-item small">
                            <img src="https://images.unsplash.com/photo-1582719471384-894fbb16e074?w=300&h=200&fit=crop" alt="News">
                            <h6>Preserving History Through Unique Accommodations</h6>
                            <a href="#">Read More</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="testimonials-section py-5">
        <div class="container">
            <h2 class="text-center mb-5">What Our<br>Customer Says</h2>
            
            <div class="testimonial-slider">
                <div class="testimonial-item">
                    <p class="testimonial-text">"The app has a user-friendly interface, so I was quickly able to find hotels that fit our needs. I can see photos of the room, available amenities, and reviews from previous guests, which helps me make an informed decision."</p>
                    <div class="testimonial-author">
                        <img src="https://i.pravatar.cc/50?img=1" alt="Khomeini Rahman">
                        <div>
                            <p class="author-name">Khomeini Rahman</p>
                            <div class="stars">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section class="newsletter-section py-5">
        <div class="container">
            <div class="newsletter-content">
                <h3>Subscribe to News and Resources</h3>
                <form class="newsletter-form" onsubmit="return handleNewsletterSignup(event)">
                    <input type="email" placeholder="Enter your email" required>
                    <button type="submit"><i class="fas fa-arrow-right"></i></button>
                </form>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer-section py-5">
        <div class="container">
            <div class="row mb-4">
                <div class="col-md-4">
                    <h5><i class="fas fa-cube"></i> GreenDoors</h5>
                    <p>Your gateway to comfort and convenience</p>
                </div>
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-3">
                            <h6>Quick Links</h6>
                            <ul>
                                <li><a href="index.php">Home</a></li>
                                <li><a href="rooms.php">Services</a></li>
                                <li><a href="booking.php">Booking</a></li>
                            </ul>
                        </div>
                        <div class="col-md-3">
                            <h6>Company</h6>
                            <ul>
                                <li><a href="#">About</a></li>
                                <li><a href="#">Contact</a></li>
                                <li><a href="#">Support</a></li>
                            </ul>
                        </div>
                        <div class="col-md-3">
                            <h6>Legal</h6>
                            <ul>
                                <li><a href="#">Privacy</a></li>
                                <li><a href="#">Terms</a></li>
                                <li><a href="#">Cookies</a></li>
                            </ul>
                        </div>
                        <div class="col-md-3">
                            <h6>Follow Us</h6>
                            <div class="social-icons">
                                <a href="#"><i class="fab fa-facebook"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="bg-secondary">
            <p class="text-center small">&copy; 2024 GreenDoors Hotel. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Set minimum dates for booking
        const today = new Date().toISOString().split('T')[0];
        document.getElementById('check_in').min = today;
        document.getElementById('check_in').value = today;
        
        document.getElementById('check_in').addEventListener('change', function() {
            const checkInDate = new Date(this.value);
            checkInDate.setDate(checkInDate.getDate() + 1);
            document.getElementById('check_out').min = checkInDate.toISOString().split('T')[0];
        });

        function handleNewsletterSignup(e) {
            e.preventDefault();
            alert('Thank you for subscribing!');
            e.target.reset();
        }
    </script>
</body>
</html>
