<?php
require_once __DIR__ . '/../includes/config.php';

// Get all room categories with their rooms
try {
    $stmt = $pdo->query("
        SELECT rc.*, COUNT(r.id) as total_rooms, 
               SUM(CASE WHEN r.status = 'available' THEN 1 ELSE 0 END) as available_rooms
        FROM room_categories rc
        LEFT JOIN rooms r ON rc.id = r.category_id
        GROUP BY rc.id
        ORDER BY rc.base_price ASC
    ");
    $categories = $stmt->fetchAll();
} catch (Exception $e) {
    $categories = [];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Room Categories - GreenDoors Hotel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/public-style.css">
    <style>
        :root {
            --primary-color: #4a7c59;
            --secondary-color: #6b9a7a;
        }
        
        .rooms-hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 60px 0;
            text-align: center;
        }
        
        .rooms-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-custom sticky-top">
        <div class="container-fluid px-4">
            <a class="navbar-brand fw-bold" href="index.php">
                <i class="fas fa-cube"></i> GreenDoors
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="rooms.php">Services</a></li>
                    <li class="nav-item"><a class="nav-link" href="#events">Events</a></li>
                    <li class="nav-item"><a class="nav-link" href="#blog">Blog</a></li>
                    <li class="nav-item"><a class="nav-link" href="booking.php">Signup</a></li>
                    <li class="nav-item"><a class="nav-link login-btn" href="../admin/login.php">LOGIN</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="rooms-hero">
        <div class="container">
            <h1>Our Room Categories</h1>
            <p>Choose the perfect room for your stay</p>
        </div>
    </section>

    <!-- Rooms Section -->
    <section class="py-5">
        <div class="container">
            <div class="rooms-grid">
                <?php foreach ($categories as $category): ?>
                    <div class="hotel-card">
                        <div class="hotel-image">
                            <img src="https://images.unsplash.com/photo-1631049307264-da0ec9d70304?w=400&h=300&fit=crop" alt="<?php echo htmlspecialchars($category['category_name']); ?>">
                            <span class="hotel-rating"><i class="fas fa-star"></i> 4.8</span>
                        </div>
                        <div class="hotel-info">
                            <h5><?php echo htmlspecialchars($category['category_name']); ?></h5>
                            <p class="location"><i class="fas fa-door-open"></i> Available: <?php echo $category['available_rooms']; ?> of <?php echo $category['total_rooms']; ?></p>
                            <p class="description"><?php echo htmlspecialchars(substr($category['description'], 0, 80)); ?>...</p>
                            
                            <div class="amenities-list mb-3">
                                <small class="text-muted">
                                    <i class="fas fa-check"></i> <?php echo htmlspecialchars(substr($category['amenities'], 0, 50)); ?>...
                                </small>
                            </div>

                            <p class="mb-2"><strong>Max Occupancy:</strong> <?php echo $category['max_occupancy']; ?> guests</p>

                            <div class="hotel-footer">
                                <span class="price">$<?php echo number_format($category['base_price'], 0); ?><small>/night</small></span>
                                <a href="booking.php?category_id=<?php echo $category['id']; ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-calendar-check"></i> Book Now
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <?php if (empty($categories)): ?>
                <div class="alert alert-info text-center mt-5" role="alert">
                    <i class="fas fa-info-circle"></i> No room categories available at the moment
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer-section py-5">
        <div class="container">
            <div class="row mb-4">
                <div class="col-md-4">
                    <h5><i class="fas fa-cube"></i> GreenDoors</h5>
                    <p>Your gateway to comfort and convenience</p>
                </div>
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-3">
                            <h6>Quick Links</h6>
                            <ul>
                                <li><a href="index.php">Home</a></li>
                                <li><a href="rooms.php">Services</a></li>
                                <li><a href="booking.php">Booking</a></li>
                            </ul>
                        </div>
                        <div class="col-md-3">
                            <h6>Company</h6>
                            <ul>
                                <li><a href="#">About</a></li>
                                <li><a href="#">Contact</a></li>
                                <li><a href="#">Support</a></li>
                            </ul>
                        </div>
                        <div class="col-md-3">
                            <h6>Legal</h6>
                            <ul>
                                <li><a href="#">Privacy</a></li>
                                <li><a href="#">Terms</a></li>
                                <li><a href="#">Cookies</a></li>
                            </ul>
                        </div>
                        <div class="col-md-3">
                            <h6>Follow Us</h6>
                            <div class="social-icons">
                                <a href="#"><i class="fab fa-facebook"></i></a>
                                <a href="#"><i class="fab fa-twitter"></i></a>
                                <a href="#"><i class="fab fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="bg-secondary">
            <p class="text-center small">&copy; 2024 GreenDoors Hotel. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
